/* batch_Goal_TDColors.jsx — GOAL! stroke-only in Primary; TeamName text+stroke-only with 70% Smart Secondary; plus TD/Solid/Logo */
(function () {
  // --- load gl_common.jsxinc (env first, hard-coded fallback) ---
  (function (){
    var DEFAULT_COMMON = File("/Users/zacharyladonis/Documents/GLANCE/Scoring Animations/gl_common.jsxinc"); // <- change if needed
    var envPath = $.getenv("AE_COMMON_JSX");
    var COMMON  = envPath ? File(envPath) : DEFAULT_COMMON;
    if (COMMON && COMMON.exists) { try { delete $.global.GL; } catch(e) {} $.evalFile(COMMON); }
    if (!$.global.GL) throw new Error("Common library not loaded: " + (COMMON?COMMON.fsName:"<none>"));
  })();
  var GL = $.global.GL;

  // --- env & defaults ---
  var PROJECT     = GL.env("AE_PROJECT", null);
  var CSV_PATH    = GL.env("AE_CSV", null);
  var COMP_NAME   = GL.env("AE_COMP", "GOAL-192");

  var LAYER_GOAL_TEXT = GL.cleanValue(GL.env("AE_LAYER_GOAL_TEXT", "GOAL!"));
  var LAYER_TD_PRE    = GL.cleanValue(GL.env("AE_LAYER_TD_PRE",  "TD PreComp"));
  var LAYER_SOLID     = GL.cleanValue(GL.env("AE_SOLID_LAYER",   "Solid"));
  var LAYER_TEAMNAME  = GL.cleanValue(GL.env("AE_TEAMNAME_LAYER","TeamName"));

  var LAYER_LOGO_PRECOMP       = GL.cleanValue(GL.env("AE_LAYER_LOGO_PRECOMP", "LogoPreComp"));
  var SUBLAYER_LOGO_IN_PRECOMP = GL.cleanValue(GL.env("AE_SUBLAYER_LOGO_IN_PRECOMP", "Logo"));
  var LAYER_LOGO_FLAT          = GL.cleanValue(GL.env("AE_LAYER_LOGO", "Logo"));

  var OUTDIR   = GL.env("AE_OUTDIR", "");
  var PATH_TPL = GL.env("AE_PATH_TEMPLATE", "{league}");
  var ANIM_NAME= GL.env("AE_ANIM", "GOAL_1_3");
  var RS_TPL   = GL.env("AE_RS_TEMPLATE", "Best Settings");
  var OM_TPL   = GL.env("AE_OM_TEMPLATE", "PNG Sequence");

  var LEAGUE   = GL.env("AE_LEAGUE", "");
  var PURGE    = (GL.env("AE_PURGE_BEFORE_RENDER", "1")==="1");
  var NO_RENDER= (GL.env("AE_NO_RENDER", "0")==="1");
  var QUIT_APP = (GL.env("AE_QUIT", "1")==="1");

  // text-mode for TeamName: "display" (displayName) or "abbr"
  var TEAMNAME_TEXT_MODE = (function(){ 
    var m=String(GL.env("AE_TEAMNAME_TEXT_MODE","display")||"").toLowerCase(); 
    return (m==="abbr"?"abbr":"display"); 
    })();

  // Optional width overrides (leave blank to keep)
  var GOAL_STROKE_WIDTH     = (function(){ var v=GL.env("AE_GOAL_STROKE_WIDTH", ""); return (v===""? null : Number(v)); })();
  var TEAMNAME_STROKE_WIDTH = (function(){ var v=GL.env("AE_TEAMNAME_STROKE_WIDTH", ""); return (v===""? null : Number(v)); })();

  var logoOpts = { dir:GL.env("AE_LOGO_DIR",""),
                   tpl:GL.env("AE_LOGO_PATH_TEMPLATE","{league}/{abbr}"),
                   exts:GL.env("AE_LOGO_EXTS","png,jpg,jpeg,svg,ai,psd") };

  // --- open project + csv ---
  if(!PROJECT) GL.fail("AE_PROJECT env not set.");
  var aep = new File(PROJECT); if(!aep.exists) GL.fail("AE_PROJECT not found: "+PROJECT);
  try{ var already = app.project && app.project.file && (app.project.file.fsName === aep.fsName); if (!already) app.open(aep);}catch(e){ app.open(aep); }

  if(!CSV_PATH) GL.fail("AE_CSV env not set.");
  if(!LEAGUE || GL.cleanValue(LEAGUE)==="") GL.fail("AE_LEAGUE is required.");

  var rows   = GL.parseCSV(GL.openRead(CSV_PATH));
  var teams  = GL.buildTeams(rows, LEAGUE);
  var todo   = GL.pickTeamsLeagueOnly(teams, LEAGUE);
  if(!todo.length) GL.fail("No teams matched league: "+LEAGUE);

  var comp = GL.findComp(COMP_NAME);
  if(!comp) GL.fail("Comp not found: "+COMP_NAME);

  var rootOut = OUTDIR ? new Folder(OUTDIR) : (app.project.file ? app.project.file.parent : Folder.desktop);
  GL.ensureFolder(rootOut);

  if (app.beginSuppressDialogs){ try{ app.beginSuppressDialogs(); }catch(e){} }
  app.beginUndoGroup("GOAL/TeamName stroke-only + colors");

  // --- helpers ---
  function clamp01(x){ return Math.min(1, Math.max(0, x)); }
  function scaleBrightnessRGB(c, target){ var t=clamp01(Number(target||0.7)); return [clamp01(c[0]*t),clamp01(c[1]*t),clamp01(c[2]*t)]; }

  function disableFillEffectsAndOverlay(layer){
    try{ var fx=layer.property("Effects"); if (fx){ var fill=fx.property("Fill")||fx.property("ADBE Fill"); if (fill && fill.enabled!==undefined) fill.enabled=false; } }catch(e){}
    try{ var ls=layer.property("Layer Styles"); if (ls){ var co=ls.property("Color Overlay"); if (co && co.enabled!==undefined) co.enabled=false; } }catch(e){}
  }
  function setTextStrokeOnly(layer, rgb, widthOrNull){
    try{
      var tp=layer.property("ADBE Text Properties").property("ADBE Text Document");
      var doc=tp.value;
      doc.applyFill=false;
      doc.applyStroke=true;
      doc.strokeColor=rgb;
      if (widthOrNull!==null && !isNaN(widthOrNull)) doc.strokeWidth=Number(widthOrNull);
      tp.setValue(doc);
    }catch(e){}
    try{ // mirror to Layer Styles Stroke if present
      var ls=layer.property("Layer Styles"); if(ls){ var st=ls.property("Stroke"); if(st){ var c=st.property("Color"); if(c) c.setValue(rgb); if (widthOrNull!==null){ var sz=st.property("Size"); if(sz) sz.setValue(Number(widthOrNull)); } } }
    }catch(e){}
    disableFillEffectsAndOverlay(layer);
  }
  function setFillOnAny(layer, rgb){
    try{ var fx=layer.property("Effects").property("Fill")||layer.property("Effects").property("ADBE Fill"); if (fx){ var p=fx.property("Color"); if(p){ p.setValue(rgb); return true; }}}catch(e){}
    try{ if (layer.source && layer.source.mainSource && layer.source.mainSource instanceof SolidSource){ layer.source.mainSource.color=rgb; return true; } }catch(e){}
    return false;
  }
  function setTextStroke(layer, rgb, width){
    try{ var tp=layer.property("ADBE Text Properties").property("ADBE Text Document"); var doc=tp.value; doc.applyStroke=true; doc.strokeColor=rgb; if(width!==null){ doc.strokeWidth=width; } tp.setValue(doc); return true; }catch(e){}
    try{ var ls=layer.property("Layer Styles"); if (ls){ var st=ls.property("Stroke"); if(st){ var c=st.property("Color"); if(c) c.setValue(rgb); if(width!==null){ var sz=st.property("Size"); if (sz) sz.setValue(width); } return true; } } }catch(e){}
    try{ var fx=layer.property("Effects"); if (fx){ var s=fx.property("Stroke")||fx.property("ADBE Stroke"); if(s){ var cp=s.property("Color"); if(cp) cp.setValue(rgb); return true; } } }catch(e){}
    return false;
  }
  function findOrImportFootage(filePath){
    var f=new File(filePath); if (!f.exists) return null; var fs=f.fsName;
    for (var i=1;i<=app.project.numItems;i++){ var it=app.project.item(i); try{ if (it instanceof FootageItem && it.file && it.file.fsName===fs) return it; }catch(e){} }
    try{ var io=new ImportOptions(f); io.importAs=ImportAsType.FOOTAGE; return app.project.importFile(io); }catch(e){ return null; }
  }
  function resolveLogoPath(league, abbr, opts){
    var dir=(opts.dir||"").replace(/\/+$/,""), tpl=(opts.tpl||"{league}/{abbr}"), exts=String(opts.exts||"png").split(",");
    var rel=tpl.replace("{league}",String(league||"")).replace("{abbr}",String(abbr||""));
    for (var i=0;i<exts.length;i++){ var fp=dir+"/"+rel+"."+GL.cleanValue(exts[i]); var f=new File(fp); if(f.exists) return f.fsName; }
    return null;
  }
  function replaceLogo(compRoot, logoPath){
    if(!logoPath) return;
    var footage=findOrImportFootage(logoPath); if(!footage) return;
    var preL=GL.getLayer(compRoot, LAYER_LOGO_PRECOMP);
    if(preL && preL.source && (preL.source instanceof CompItem)){
      var sub=preL.source;
      for (var i=1;i<=sub.numLayers;i++){ var L=sub.layer(i); if(L.name===SUBLAYER_LOGO_IN_PRECOMP && L.source){ try{ L.replaceSource(footage,false);}catch(e){} } }
    }
    var flat=GL.getLayer(compRoot, LAYER_LOGO_FLAT);
    if(flat && flat.source){ try{ flat.replaceSource(footage,false);}catch(e){} }
  }
  function colorizeTDPrecompToPrimary(rootComp, primaryRGB){
    var L=GL.getLayer(rootComp, LAYER_TD_PRE);
    if(!L || !L.source || !(L.source instanceof CompItem)) return 0;
    var sub=L.source; var hits=0;
    for (var i=1;i<=sub.numLayers;i++){ var sL=sub.layer(i); if(sL.name==="TOUCH"||sL.name==="DOWN"){ if(setTextStroke(sL,primaryRGB,null)) hits++; } }
    return hits;
  }

  // --- team loop ---
  for (var i=0;i<todo.length;i++){
    var t = todo[i];
    var smart = GL.computeSmartColors(GL.safeColor(t.primary), GL.safeColor(t.secondary));
    var P = GL.safeColor(GL.ensureNonBlack(smart.primary));     // Primary
    var S = GL.safeColor(GL.ensureNonBlack(smart.secondary));   // Secondary
    var S70 = scaleBrightnessRGB(S, 0.70);                      // 70% brightness of Smart Secondary

    // 1) Logo
    replaceLogo(comp, resolveLogoPath(t.league, t.abbr, logoOpts));

    // 2) GOAL! — STROKE ONLY in Primary
    (function(){ var L=GL.getLayer(comp, LAYER_GOAL_TEXT); if(L) setTextStrokeOnly(L, P, GOAL_STROKE_WIDTH); })();

    // 3) TD PreComp (TOUCH/DOWN) stroke → Primary
    colorizeTDPrecompToPrimary(comp, P);

    // 4) Solid fill → Primary
    (function(){ var L=GL.getLayer(comp, LAYER_SOLID); if(L) setFillOnAny(L, P); })();

    // 5) TeamName — CONTENT + STROKE ONLY in 70% Smart Secondary
    (function(){
      var L = GL.getLayer(comp, LAYER_TEAMNAME);
      if (!L) return;

      // choose label from mode
      var teamLabel = (TEAMNAME_TEXT_MODE === "abbr")
        ? String(t.abbr||"")
        : (t.name && String(t.name).length ? String(t.name) : String(t.abbr||""));

      try{
        var tp=L.property("ADBE Text Properties").property("ADBE Text Document");
        var doc=tp.value;
        doc.text = teamLabel;
        doc.applyFill=false;
        doc.applyStroke=true;
        doc.strokeColor=S70;
        if (TEAMNAME_STROKE_WIDTH!==null && !isNaN(TEAMNAME_STROKE_WIDTH)) doc.strokeWidth=Number(TEAMNAME_STROKE_WIDTH);
        tp.setValue(doc);
      }catch(e){}
      setTextStroke(L, S70, TEAMNAME_STROKE_WIDTH);   // layer-style fallback
      disableFillEffectsAndOverlay(L);                // ensure no fill slips in
    })();

    GL.snapCompTextForPixelArt(comp);
    if (PURGE && app.purge){ try{ app.purge(PurgeTarget.ALL_CACHES); }catch(e){} }

    if (!NO_RENDER){
      var lc=GL.leagueAndConfForPath(t.league, t.conference);
      var paths=GL.outPaths(rootOut, PATH_TPL, lc.base, t.abbr, ANIM_NAME, lc.conf, t.espn_team_id);
      $.writeln("Output → " + paths.file.fsName);
      GL.rqRenderTo(comp, RS_TPL, OM_TPL, paths.file);
    }

    // Clean up logo from project after render
    var removed = GL.removeLogoByAbbr(t.abbr);
    if (removed > 0) $.writeln("Removed " + removed + " logo(s) for " + t.abbr);
  }

  app.endUndoGroup();
  if (app.endSuppressDialogs){ try{ app.endSuppressDialogs(); }catch(e){} }
  if (QUIT_APP) app.quit();
})();
